function draw_prior_all(X, Y, method, feature_num)
% DRAW_PRIOR_ALL Draws the prior distributions for all feature pairs using Naive Bayes
%   X           : Feature matrix
%   Y           : Class labels
%   method      : Naive Bayes distribution type (only supports 'normal' here)
%   feature_num : Total number of features (columns in X)

    % Only perform the operation if the distribution method is 'normal'
    if strcmp(method, 'normal')
        % Iterate over all pairs of features (i, j) with i < j
        for i = 1:feature_num-1
            for j = i+1:feature_num
                % Call draw_prior to plot the distribution for the i-th and j-th features
                draw_prior(X, Y, method, i, j);
            end
        end
    end
end
